/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RallyTheRighteousBoostEffect
extends ContinuousEffectImpl {
    RallyTheRighteousBoostEffect() {
        super(Duration.EndOfTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Those creatures get +2/+0 until end of turn";
    }

    private RallyTheRighteousBoostEffect(RallyTheRighteousBoostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target != null) {
            this.affectedObjectList.add(new MageObjectReference((MageObject)target, game));
            ObjectColor color = target.getColor(game);
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                if (permanent.getId().equals(target.getId()) || !permanent.getColor(game).shares(color)) continue;
                this.affectedObjectList.add(new MageObjectReference((MageObject)permanent, game));
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        for (MageObjectReference mageObjectReference : this.affectedObjectList) {
            Permanent permanent = mageObjectReference.getPermanent(game);
            if (permanent == null) continue;
            permanent.addPower(2);
        }
        return true;
    }

    public RallyTheRighteousBoostEffect copy() {
        return new RallyTheRighteousBoostEffect(this);
    }
}

