/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactOrEnchantmentPermanent;
import mage.game.Game;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class RampagingYaoGuaiTarget
extends TargetPermanent {
    private static final FilterPermanent filterStatic = new FilterArtifactOrEnchantmentPermanent("artifacts and/or enchantments with total mana value X or less");

    RampagingYaoGuaiTarget() {
        super(0, Integer.MAX_VALUE, filterStatic, false);
    }

    private RampagingYaoGuaiTarget(RampagingYaoGuaiTarget target) {
        super((TargetPermanent)target);
    }

    public RampagingYaoGuaiTarget copy() {
        return new RampagingYaoGuaiTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return super.canTarget(playerId, id, source, game) && CardUtil.checkCanTargetTotalValueLimit((Collection)this.getTargets(), (UUID)id, MageObject::getManaValue, (int)GetXValue.instance.calculate(game, source, null), (Game)game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        return CardUtil.checkPossibleTargetsTotalValueLimit((Collection)this.getTargets(), (Set)super.possibleTargets(sourceControllerId, source, game), MageObject::getManaValue, (int)GetXValue.instance.calculate(game, source, null), (Game)game);
    }

    public String getMessage(Game game) {
        int selectedValue = this.getTargets().stream().map(arg_0 -> ((Game)game).getObject(arg_0)).filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
        return super.getMessage(game) + " (selected total mana value " + selectedValue + ")";
    }
}

