/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class RampantFrogantuaEffect
extends OneShotEffect {
    RampantFrogantuaEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill that many cards. Put any number of land cards from among them onto the battlefield tapped";
    }

    private RampantFrogantuaEffect(RampantFrogantuaEffect effect) {
        super((OneShotEffect)effect);
    }

    public RampantFrogantuaEffect copy() {
        return new RampantFrogantuaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int amount = SavedDamageValue.MANY.calculate(game, source, (Effect)this);
        if (player == null || amount < 1) {
            return false;
        }
        Cards cards = player.millCards(amount, source, game);
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard target = new TargetCard(0, Integer.MAX_VALUE, Zone.ALL, (FilterCard)StaticFilters.FILTER_CARD_LANDS);
        target.withNotTarget(true);
        player.choose(Outcome.DrawCard, cards, target, source, game);
        player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        return true;
    }
}

