/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class RamsesAssassinLordWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> map = new HashMap<UUID, Set<UUID>>();

    RamsesAssassinLordWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ATTACKER_DECLARED || game.getPlayer(event.getTargetId()) == null) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null && permanent.hasSubtype(SubType.ASSASSIN, game)) {
            this.map.computeIfAbsent(event.getTargetId(), x -> new HashSet()).add(permanent.getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean check(UUID defenderId, UUID controllerId, Game game) {
        return ((RamsesAssassinLordWatcher)game.getState().getWatcher(RamsesAssassinLordWatcher.class)).map.getOrDefault(defenderId, Collections.emptySet()).contains(controllerId);
    }
}

