/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class RangerCaptainOfEosEffect
extends ContinuousRuleModifyingEffectImpl {
    RangerCaptainOfEosEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Your opponents can't cast noncreature spells this turn.";
    }

    private RangerCaptainOfEosEffect(RangerCaptainOfEosEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public RangerCaptainOfEosEffect copy() {
        return new RangerCaptainOfEosEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast noncreature spells this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        return controller != null && controller.hasOpponent(event.getPlayerId(), game) && (card = game.getCard(event.getSourceId())) != null && !card.isCreature(game);
    }
}

