/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class RansackEffect
extends OneShotEffect {
    RansackEffect() {
        super(Outcome.Detriment);
        this.staticText = "Look at the top five cards of target player's library. Put any number of them on the bottom of that library in any order and the rest on top of the library in any order";
    }

    private RansackEffect(RansackEffect effect) {
        super((OneShotEffect)effect);
    }

    public RansackEffect copy() {
        return new RansackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        FilterCard filter = new FilterCard("cards to put on the bottom of your library");
        if (player != null) {
            int number = Integer.min(player.getLibrary().size(), 5);
            Set cards = player.getLibrary().getTopCards(game, number);
            CardsImpl cardsRemaining = new CardsImpl();
            cardsRemaining.addAllCards((Collection)cards);
            TargetCard target = new TargetCard(0, number, Zone.LIBRARY, filter);
            if (player.choose(Outcome.DrawCard, (Cards)cardsRemaining, target, source, game)) {
                CardsImpl pickedCards = new CardsImpl((Collection)target.getTargets());
                cardsRemaining.removeAll((Collection)pickedCards);
                player.putCardsOnBottomOfLibrary((Cards)pickedCards, game, source, true);
                player.putCardsOnTopOfLibrary((Cards)cardsRemaining, game, source, true);
                return true;
            }
        }
        return false;
    }
}

