/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.r.RatchetFieldMedicPredicate;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class RatchetFieldMedicEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterArtifactCard("artifact card with mana value less than or equal to the amount of life you gained this turn from your graveyard");

    RatchetFieldMedicEffect() {
        super(Outcome.Benefit);
        this.staticText = "convert {this}. When you do, return target artifact card with mana value less than or equal to the amount of life you gained this turn from your graveyard to the battlefield tapped";
    }

    private RatchetFieldMedicEffect(RatchetFieldMedicEffect effect) {
        super((OneShotEffect)effect);
    }

    public RatchetFieldMedicEffect copy() {
        return new RatchetFieldMedicEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.transform(source, game)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect(true), false);
        ability.addTarget((Target)new TargetCardInYourGraveyard(filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add((Predicate)RatchetFieldMedicPredicate.instance);
    }
}

