/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class RavenloftAdventurerReplacementEffect
extends ReplacementEffectImpl {
    RavenloftAdventurerReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "if a creature an opponent controls would die, instead exile it and put a hit counter on it";
    }

    private RavenloftAdventurerReplacementEffect(RavenloftAdventurerReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RavenloftAdventurerReplacementEffect copy() {
        return new RavenloftAdventurerReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || permanent == null || !controller.hasOpponent(permanent.getControllerId(), game)) {
            return false;
        }
        return CardUtil.moveCardWithCounter((Game)game, (Ability)source, (Player)controller, (Card)permanent, (Zone)Zone.EXILED, (Counter)CounterType.HIT.createInstance());
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zce = (ZoneChangeEvent)event;
        return zce.isDiesEvent() && zce.getTarget().isCreature(game);
    }
}

