/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RavenousWampaEffect
extends OneShotEffect {
    RavenousWampaEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain life equal to the sacrificed creature's toughness";
    }

    private RavenousWampaEffect(RavenousWampaEffect effect) {
        super((OneShotEffect)effect);
    }

    public RavenousWampaEffect copy() {
        return new RavenousWampaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourceObject != null) {
            Integer toughness = (Integer)game.getState().getValue("TOU_SAC_CRE" + source.getSourceId() + sourceObject.getZoneChangeCounter(game));
            if (toughness != null) {
                controller.gainLife(toughness.intValue(), game, source);
            }
            return true;
        }
        return false;
    }
}

