/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RayamiFirstOfTheFallenEffect
extends ContinuousEffectImpl {
    RayamiFirstOfTheFallenEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.addDependedToType(DependencyType.AddingAbility);
        this.staticText = "As long as an exiled creature card with a blood counter on it has flying, {this} has flying. The same is true for first strike, double strike, deathtouch, haste, hexproof, indestructible, lifelink, menace, protection, reach, trample, and vigilance.";
    }

    private RayamiFirstOfTheFallenEffect(RayamiFirstOfTheFallenEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        game.getExile().getCardsInRange(game, sourcePermanent.getControllerId()).stream().filter(card1 -> card1.isCreature(game)).filter(card -> card.getCounters(game).getCount(CounterType.BLOOD) > 0).map(card -> card.getAbilities(game)).flatMap(Collection::stream).forEach(ability -> {
            if (ability instanceof FlyingAbility || ability instanceof FirstStrikeAbility || ability instanceof DoubleStrikeAbility || ability instanceof DeathtouchAbility || ability instanceof HasteAbility || ability instanceof HexproofBaseAbility || ability instanceof IndestructibleAbility || ability instanceof LifelinkAbility || ability instanceof MenaceAbility || ability instanceof ReachAbility || ability instanceof TrampleAbility || ability instanceof VigilanceAbility || ability instanceof ProtectionAbility) {
                sourcePermanent.addAbility(ability, source.getSourceId(), game);
            }
        });
        return true;
    }

    public RayamiFirstOfTheFallenEffect copy() {
        return new RayamiFirstOfTheFallenEffect(this);
    }
}

