/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.util.CardUtil;

class RayamiFirstOfTheFallenReplacementEffect
extends ReplacementEffectImpl {
    RayamiFirstOfTheFallenReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If a nontoken creature would die, exile that card with a blood counter on it instead";
    }

    private RayamiFirstOfTheFallenReplacementEffect(RayamiFirstOfTheFallenReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RayamiFirstOfTheFallenReplacementEffect copy() {
        return new RayamiFirstOfTheFallenReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || permanent == null || permanent instanceof PermanentToken) {
            return false;
        }
        return CardUtil.moveCardWithCounter((Game)game, (Ability)source, (Player)controller, (Card)permanent, (Zone)Zone.EXILED, (Counter)CounterType.BLOOD.createInstance());
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zce = (ZoneChangeEvent)event;
        return zce.isDiesEvent() && zce.getTarget().isCreature(game) && !(zce.getTarget() instanceof PermanentToken);
    }
}

