/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RazeToTheGroundEffect
extends OneShotEffect {
    RazeToTheGroundEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact. If its mana value was 1 or less, draw a card.";
    }

    private RazeToTheGroundEffect(RazeToTheGroundEffect effect) {
        super((OneShotEffect)effect);
    }

    public RazeToTheGroundEffect copy() {
        return new RazeToTheGroundEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int manaValue = permanent.getManaValue();
        permanent.destroy(source, game);
        if (manaValue <= 1 && (controller = game.getPlayer(source.getControllerId())) != null) {
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

