/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainProtectionFromColorTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterObject;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class RazorBarrierEffect
extends OneShotEffect {
    private static final FilterObject filter = new FilterObject("colorless");

    RazorBarrierEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target permanent you control gains protection from artifacts or from the color of your choice until end of turn.";
    }

    private RazorBarrierEffect(RazorBarrierEffect effect) {
        super((OneShotEffect)effect);
    }

    public RazorBarrierEffect copy() {
        return new RazorBarrierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(this.outcome, "Give the targeted permanent protection from artifacts?", null, "Yes", "No (choose a color instead)", source, game)) {
            game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)new ProtectionAbility((Filter)filter), Duration.EndOfTurn), source);
            return true;
        }
        game.addEffect((ContinuousEffect)new GainProtectionFromColorTargetEffect(Duration.EndOfTurn), source);
        return true;
    }

    static {
        filter.add((Predicate)CardType.ARTIFACT.getPredicate());
    }
}

