/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RazorBoomerangEffect
extends OneShotEffect {
    RazorBoomerangEffect() {
        super(Outcome.Benefit);
    }

    private RazorBoomerangEffect(RazorBoomerangEffect effect) {
        super((OneShotEffect)effect);
    }

    public RazorBoomerangEffect copy() {
        return new RazorBoomerangEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object object = this.getValue("attachedPermanent");
        Player player = game.getPlayer(source.getControllerId());
        if (!(object instanceof Permanent) || player == null) {
            return false;
        }
        Permanent permanent = (Permanent)object;
        Permanent targetedPermanent = game.getPermanent(source.getFirstTarget());
        if (targetedPermanent == null) {
            Player targetedPlayer = game.getPlayer(source.getFirstTarget());
            if (targetedPlayer != null) {
                targetedPlayer.damage(1, permanent.getId(), source, game);
            }
        } else {
            targetedPermanent.damage(1, permanent.getId(), source, game);
        }
        return player.moveCards((Card)permanent, Zone.HAND, source, game);
    }

    public String getText(Mode mode) {
        String name = "Razor Boomerang";
        Object object = this.getValue("attachedPermanent");
        if (object instanceof Permanent) {
            name = ((Permanent)object).getName();
        }
        return name + " deals 1 damage to any target. Return " + name + " to its owner's hand.";
    }
}

