/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.costs.CostAdjuster;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Controllable;
import mage.game.Game;
import mage.util.CardUtil;

enum RazorlashTransmograntAdjuster implements CostAdjuster
{
    instance;

    private static final FilterPermanent filter;

    public void reduceCost(Ability ability, Game game) {
        if (RazorlashTransmograntAdjuster.makeMap(game, ability).values().stream().anyMatch(x -> x >= 4)) {
            CardUtil.reduceCost((Ability)ability, (int)4);
        }
    }

    static Map<UUID, Integer> makeMap(Game game, Ability ability) {
        return game.getBattlefield().getActivePermanents(filter, ability.getControllerId(), ability, game).stream().collect(Collectors.toMap(Controllable::getControllerId, x -> 1, Integer::sum));
    }

    static {
        filter = new FilterLandPermanent();
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
    }
}

