/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

class ReadTheRunesEffect
extends OneShotEffect {
    ReadTheRunesEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw X cards. For each card drawn this way, discard a card unless you sacrifice a permanent.";
    }

    private ReadTheRunesEffect(ReadTheRunesEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReadTheRunesEffect copy() {
        return new ReadTheRunesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int drawnCards = controller.drawCards(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), source, game);
            TargetSacrifice target = new TargetSacrifice(0, drawnCards, StaticFilters.FILTER_PERMANENT);
            controller.choose(Outcome.Sacrifice, (Target)target, source, game);
            int sacrificedPermanents = 0;
            for (UUID permanentId : target.getTargets()) {
                Permanent permanent = game.getPermanent(permanentId);
                if (permanent == null || !permanent.sacrifice(source, game)) continue;
                ++sacrificedPermanents;
            }
            controller.discard(drawnCards - sacrificedPermanents, false, false, source, game);
            return true;
        }
        return false;
    }
}

