/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.EnumSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RealityScrambleEffect
extends OneShotEffect {
    RealityScrambleEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put target permanent you own on the bottom of your library. Reveal cards from the top of your library until you reveal a card that shares a card type with that permanent. Put that card onto the battlefield and the rest on the bottom of your library in a random order.";
    }

    private RealityScrambleEffect(RealityScrambleEffect effect) {
        super((OneShotEffect)effect);
    }

    public RealityScrambleEffect copy() {
        return new RealityScrambleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent == null || controller == null) {
            return false;
        }
        EnumSet<CardType> types = EnumSet.noneOf(CardType.class);
        types.addAll(permanent.getCardType(game));
        controller.putCardsOnBottomOfLibrary((Cards)new CardsImpl((Card)permanent), game, source, false);
        CardsImpl toReveal = new CardsImpl();
        Card cardToPlay = null;
        for (Card card : controller.getLibrary().getCards(game)) {
            toReveal.add(card);
            for (CardType type : types) {
                if (!card.getCardType(game).contains(type)) continue;
                cardToPlay = card;
                break;
            }
            if (cardToPlay == null) continue;
            break;
        }
        controller.revealCards(source, (Cards)toReveal, game);
        if (cardToPlay != null) {
            controller.moveCards(cardToPlay, Zone.BATTLEFIELD, source, game);
            toReveal.remove(cardToPlay);
        }
        controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        return true;
    }
}

