/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestTargetPlayerEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RealityShiftEffect
extends OneShotEffect {
    RealityShiftEffect() {
        super(Outcome.Exile);
        this.staticText = "Its controller manifests the top card of their library. <i>(That player puts the top card of their library onto the battlefield face down as a 2/2 creature. If it's a creature card, it can be turned face up any time for its mana cost.)</i>";
    }

    private RealityShiftEffect(RealityShiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public RealityShiftEffect copy() {
        return new RealityShiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (targetCreature != null) {
            ManifestTargetPlayerEffect effect = new ManifestTargetPlayerEffect(1, "Its controller");
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature.getControllerId()));
            return effect.apply(game, source);
        }
        return false;
    }
}

