/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;

class RealmRazerEffect
extends OneShotEffect {
    RealmRazerEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "return the exiled cards to the battlefield tapped under their owners' control";
    }

    private RealmRazerEffect(RealmRazerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RealmRazerEffect copy() {
        return new RealmRazerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ExileZone exZone = game.getExile().getExileZone(source.getSourceId());
            if (exZone != null) {
                return controller.moveCards(exZone.getCards(game), Zone.BATTLEFIELD, source, game, true, false, true, null);
            }
            return true;
        }
        return false;
    }
}

