/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.replacement.LeaveBattlefieldExileSourceReplacementEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class RealmbreakerTheInvasionTreeEffect
extends OneShotEffect {
    RealmbreakerTheInvasionTreeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put a land card from their graveyard onto the battlefield tapped under your control. It gains \"If this land would leave the battlefield, exile it instead of putting it anywhere else.\"";
    }

    private RealmbreakerTheInvasionTreeEffect(RealmbreakerTheInvasionTreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RealmbreakerTheInvasionTreeEffect copy() {
        return new RealmbreakerTheInvasionTreeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null || opponent.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) < 1) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_LAND);
        target.withNotTarget(true);
        controller.choose(Outcome.PutLandInPlay, (Cards)opponent.getGraveyard(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)new SimpleStaticAbility((Effect)new LeaveBattlefieldExileSourceReplacementEffect("this land")), Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

