/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;

class ReboundEffect
extends OneShotEffect {
    ReboundEffect() {
        super(Outcome.Neutral);
        this.staticText = "Change the target of target spell that targets only a player. The new target must be a player";
    }

    private ReboundEffect(ReboundEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReboundEffect copy() {
        return new ReboundEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (spell != null && controller != null) {
            spell.getSpellAbility().getTargets().clear();
            TargetPlayer targetPlayer = new TargetPlayer();
            if (controller.choose(Outcome.Neutral, (Target)targetPlayer, source, game)) {
                spell.getSpellAbility().addTarget((Target)targetPlayer);
                game.informPlayers("The target of the spell was changed to " + targetPlayer.getTargetedName(game));
                return true;
            }
        }
        return false;
    }
}

