/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class RecklessEndeavorEffect
extends OneShotEffect {
    RecklessEndeavorEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll two d12 and choose one result. {this} deals damage equal to that result to each creature. Then create a number of Treasure tokens equal to the other result";
    }

    private RecklessEndeavorEffect(RecklessEndeavorEffect effect) {
        super((OneShotEffect)effect);
    }

    public RecklessEndeavorEffect copy() {
        return new RecklessEndeavorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int second;
        int first;
        int secondResult;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List results = player.rollDice(this.outcome, source, game, 12, 2, 0);
        int firstResult = (Integer)results.get(0);
        if (firstResult != (secondResult = ((Integer)results.get(1)).intValue()) && player.chooseUse(this.outcome, "Choose a number to deal damage to each creature", "The other number will be the amount of treasures you create", "" + firstResult, "" + secondResult, source, game)) {
            first = firstResult;
            second = secondResult;
        } else {
            first = secondResult;
            second = firstResult;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
            permanent.damage(first, source.getSourceId(), source, game);
        }
        new TreasureToken().putOntoBattlefield(second, game, source, source.getControllerId());
        return true;
    }
}

