/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RecklessHandlingEffect
extends OneShotEffect {
    RecklessHandlingEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then discard a card at random. If an artifact card was discarded this way, {this} deals 2 damage to each opponent";
    }

    private RecklessHandlingEffect(RecklessHandlingEffect effect) {
        super((OneShotEffect)effect);
    }

    public RecklessHandlingEffect copy() {
        return new RecklessHandlingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        Card card = player.discard(1, true, false, source, game).getRandom(game);
        if (card == null || !card.isArtifact(game)) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            opponent.damage(2, source, game);
        }
        return true;
    }
}

