/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.Alien00Token;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ReconCraftThetaEffect
extends OneShotEffect {
    ReconCraftThetaEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 0/0 blue Alien creature token. Put a +1/+1 counter on it.";
    }

    private ReconCraftThetaEffect(ReconCraftThetaEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReconCraftThetaEffect copy() {
        return new ReconCraftThetaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenEffect tokenEffect = new CreateTokenEffect((Token)new Alien00Token());
        if (!tokenEffect.apply(game, source)) {
            return false;
        }
        List tokens = tokenEffect.getLastAddedTokenIds().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        new AddCountersTargetEffect(CounterType.P1P1.createInstance()).setTargetPointer((TargetPointer)new FixedTargets(tokens, game)).apply(game, source);
        return true;
    }
}

