/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class RediscoverTheWayTriggeredAbility
extends DelayedTriggeredAbility {
    RediscoverTheWayTriggeredAbility() {
        super((Effect)new GainAbilityTargetEffect((Ability)DoubleStrikeAbility.getInstance()), Duration.EndOfTurn, false, false);
        this.addTarget((Target)new TargetControlledCreaturePermanent());
        this.setTriggerPhrase("Whenever you cast a noncreature spell this turn, ");
    }

    private RediscoverTheWayTriggeredAbility(RediscoverTheWayTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public RediscoverTheWayTriggeredAbility copy() {
        return new RediscoverTheWayTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getSpell(event.getTargetId());
        return spell != null && !spell.isCreature(game);
    }
}

