/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.EnteredThisTurnPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class RedoubledStormsingerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    RedoubledStormsingerEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each creature token you control that entered this turn, create a tapped and attacking token that's a copy of that token. At the beginning of the next end step, sacrifice those tokens";
    }

    private RedoubledStormsingerEffect(RedoubledStormsingerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RedoubledStormsingerEffect copy() {
        return new RedoubledStormsingerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet addedTokens = new HashSet();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, true, true).setSavedPermanent(permanent);
            effect.apply(game, source);
            addedTokens.addAll(effect.getAddedPermanents());
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(addedTokens, game))), source);
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        filter.add((Predicate)EnteredThisTurnPredicate.instance);
    }
}

