/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.AbilityImpl;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ReflectiveGolemTriggeredAbility
extends TriggeredAbilityImpl {
    ReflectiveGolemTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new CopyTargetStackObjectEffect(), (Cost)new GenericManaCost(2)), false);
    }

    private ReflectiveGolemTriggeredAbility(ReflectiveGolemTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ReflectiveGolemTriggeredAbility copy() {
        return new ReflectiveGolemTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getSpellOrLKIStack(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        if (spell.getSpellAbilities().stream().map(AbilityImpl::getModes).flatMap(m -> m.getSelectedModes().stream().map(arg_0 -> ((Modes)m).get(arg_0))).filter(Objects::nonNull).map(Mode::getTargets).flatMap(Collection::stream).filter(t -> !t.isNotTarget()).map(Target::getTargets).flatMap(Collection::stream).filter(Objects::nonNull).distinct().filter(this.getSourceId()::equals).count() != 1L) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget((Card)spell, game));
        return true;
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell that targets only {this}, you may pay {2}. If you do, copy that spell. You may choose new targets for the copy.";
    }
}

