/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.TargetSource;

class RefractionTrapPreventDamageEffect
extends PreventionEffectImpl {
    private final TargetSource target;
    private final int amount;

    public RefractionTrapPreventDamageEffect(Duration duration, int amount) {
        super(duration, amount, false, false);
        this.amount = amount;
        this.target = new TargetSource();
        this.staticText = "The next " + amount + " damage that a source of your choice would deal to you and/or permanents you control this turn. If damage is prevented this way, {this} deals that much damage to any target";
    }

    private RefractionTrapPreventDamageEffect(RefractionTrapPreventDamageEffect effect) {
        super((PreventionEffectImpl)effect);
        this.amount = effect.amount;
        this.target = effect.target.copy();
    }

    public RefractionTrapPreventDamageEffect copy() {
        return new RefractionTrapPreventDamageEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.target.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionData = this.preventDamageAction(event, source, game);
        this.used = true;
        this.discard();
        if (preventionData.getPreventedDamage() > 0) {
            Player player;
            UUID damageTarget = this.getTargetPointer().getFirst(game, source);
            Permanent permanent = game.getPermanent(damageTarget);
            if (permanent != null) {
                game.informPlayers("Dealing " + preventionData.getPreventedDamage() + " to " + permanent.getLogName());
                permanent.damage(preventionData.getPreventedDamage(), source.getSourceId(), source, game, false, true);
            }
            if ((player = game.getPlayer(damageTarget)) != null) {
                game.informPlayers("Dealing " + preventionData.getPreventedDamage() + " to " + player.getLogName());
                player.damage(preventionData.getPreventedDamage(), source.getSourceId(), source, game);
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used && super.applies(event, source, game)) {
            MageObject object = game.getObject(event.getSourceId());
            if (object == null) {
                game.informPlayers("Couldn't find source of damage");
                return false;
            }
            if (!(object.getId().equals(this.target.getFirstTarget()) || object instanceof StackObject && ((StackObject)object).getSourceId().equals(this.target.getFirstTarget()))) {
                return false;
            }
            Permanent permanent = game.getPermanent(event.getTargetId());
            if (permanent != null && permanent.isControlledBy(source.getControllerId())) {
                return true;
            }
            Player player = game.getPlayer(event.getTargetId());
            if (player != null) {
                return player.getId().equals(source.getControllerId());
            }
        }
        return false;
    }
}

