/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapAllEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ReinsOfPowerEffect
extends OneShotEffect {
    ReinsOfPowerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Untap all creatures you control and all creatures target opponent controls. You and that opponent each gain control of all creatures the other controls until end of turn. Those creatures gain haste until end of turn";
    }

    private ReinsOfPowerEffect(ReinsOfPowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReinsOfPowerEffect copy() {
        return new ReinsOfPowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID opponentId = this.getTargetPointer().getFirst(game, source);
        if (opponentId != null) {
            GainControlTargetEffect effect;
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add(Predicates.or((Predicate)new ControllerIdPredicate(source.getControllerId()), (Predicate)new ControllerIdPredicate(opponentId)));
            new UntapAllEffect((FilterPermanent)filter).apply(game, source);
            HashSet<UUID> yourCreatures = new HashSet<UUID>();
            HashSet<UUID> opponentCreatures = new HashSet<UUID>();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterControlledCreaturePermanent(), source.getControllerId(), source, game)) {
                yourCreatures.add(permanent.getId());
            }
            FilterCreaturePermanent filterOpponent = new FilterCreaturePermanent();
            filterOpponent.add((Predicate)new ControllerIdPredicate(opponentId));
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filterOpponent, source.getControllerId(), source, game)) {
                opponentCreatures.add(permanent.getId());
            }
            for (UUID creatureId : yourCreatures) {
                effect = new GainControlTargetEffect(Duration.EndOfTurn, opponentId);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creatureId, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            for (UUID creatureId : opponentCreatures) {
                effect = new GainControlTargetEffect(Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creatureId, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            game.addEffect((ContinuousEffect)new GainAbilityAllEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter), source);
            return true;
        }
        return false;
    }
}

