/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.abilities.effects.common.counter.ProliferateEffect;
import mage.constants.Outcome;
import mage.game.Game;

class RejectImperfectionEffect
extends OneShotEffect {
    RejectImperfectionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell. If that spell's mana value was 3 or less, proliferate. <i>(Choose any number of permanents and/or players, then give each another counter of each kind already there.)</i>";
    }

    private RejectImperfectionEffect(RejectImperfectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public RejectImperfectionEffect copy() {
        return new RejectImperfectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject object = game.getObject(source.getFirstTarget());
        if (object == null) {
            return false;
        }
        new CounterTargetEffect().apply(game, source);
        int manaValue = object.getManaValue();
        if (manaValue <= 3) {
            new ProliferateEffect().apply(game, source);
        }
        return true;
    }
}

