/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class RelentlessRats
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public RelentlessRats(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{B}{B}");
        this.subtype.add((Object)SubType.RAT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new RelentlessRatsEffect()));
        this.getSpellAbility().addEffect((Effect)new InfoEffect("A deck can have any number of cards named Relentless Rats."));
    }

    private RelentlessRats(RelentlessRats card) {
        super((CardImpl)card);
    }

    public RelentlessRats copy() {
        return new RelentlessRats(this);
    }

    static {
        filter.add((Predicate)new NamePredicate("Relentless Rats"));
    }

    static class RelentlessRatsEffect
    extends ContinuousEffectImpl {
        public RelentlessRatsEffect() {
            super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
            this.staticText = "{this} gets +1/+1 for each other creature on the battlefield named Relentless Rats";
        }

        private RelentlessRatsEffect(RelentlessRatsEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public RelentlessRatsEffect copy() {
            return new RelentlessRatsEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent target;
            int count = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) - 1;
            if (count > 0 && (target = game.getPermanent(source.getSourceId())) != null) {
                target.addPower(count);
                target.addToughness(count);
                return true;
            }
            return false;
        }
    }
}

