/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCardInLibrary;

class RemembranceTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    RemembranceTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, true);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private RemembranceTriggeredAbility(RemembranceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RemembranceTriggeredAbility copy() {
        return new RemembranceTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((ZoneChangeEvent)event).isDiesEvent()) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent != null && filter.match((Object)permanent, game)) {
            FilterCard filterCard = new FilterCard("card named " + permanent.getName());
            filterCard.add((Predicate)new NamePredicate(permanent.getName()));
            this.getEffects().clear();
            this.addEffect((Effect)new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filterCard), true));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a nontoken creature you control dies, you may search your library for a card with the same name as that creature, reveal it, put it into your hand, then shuffle.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

