/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class RenderSilentEffect
extends ContinuousRuleModifyingEffectImpl {
    RenderSilentEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Its controller can't cast spells this turn";
    }

    private RenderSilentEffect(RenderSilentEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public RenderSilentEffect copy() {
        return new RenderSilentEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast spells this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        return player != null && player.getId().equals(event.getPlayerId());
    }
}

