/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;

class ReparationsTriggeredAbility
extends TriggeredAbilityImpl {
    public ReparationsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), true);
    }

    private ReparationsTriggeredAbility(ReparationsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ReparationsTriggeredAbility copy() {
        return new ReparationsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID stackObjectId = event.getTargetId();
        UUID casterId = event.getPlayerId();
        StackObject stackObject = game.getStack().getStackObject(stackObjectId);
        if (stackObject != null && game.getOpponents(this.controllerId).contains(casterId)) {
            Player targetPlayer = game.getPlayer(stackObject.getStackAbility().getFirstTarget());
            Permanent targetPermanent = game.getPermanent(stackObject.getStackAbility().getFirstTarget());
            if (targetPlayer != null && targetPlayer.getId().equals(this.controllerId)) {
                return true;
            }
            if (targetPermanent != null && targetPermanent.isCreature(game) && targetPermanent.isControlledBy(this.controllerId)) {
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent casts a spell that targets you or a creature you control, you may draw a card.";
    }
}

