/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RepayInKindEffect
extends OneShotEffect {
    RepayInKindEffect() {
        super(Outcome.Tap);
        this.staticText = "Each player's life total becomes the lowest life total among all players";
    }

    private RepayInKindEffect(RepayInKindEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int lowestLife = game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).mapToInt(Player::getLife).min().orElse(0);
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.setLife(lowestLife, game, source);
        }
        return true;
    }

    public RepayInKindEffect copy() {
        return new RepayInKindEffect(this);
    }
}

