/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.cards.r.RepeatedReverberationEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RepeatedReverberationTriggeredAbility
extends DelayedTriggeredAbility {
    RepeatedReverberationTriggeredAbility() {
        super(null, Duration.EndOfTurn);
    }

    private RepeatedReverberationTriggeredAbility(RepeatedReverberationTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public RepeatedReverberationTriggeredAbility copy() {
        return new RepeatedReverberationTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY || event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        StackAbility stackAbility;
        if (!event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        if (event.getType() == GameEvent.EventType.ACTIVATED_ABILITY && (stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId())) != null && stackAbility.getStackAbility() instanceof LoyaltyAbility) {
            this.getEffects().clear();
            this.addEffect((Effect)new RepeatedReverberationEffect().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game)));
            return true;
        }
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isInstantOrSorcery(game)) {
            this.getEffects().clear();
            this.addEffect((Effect)new CopyTargetStackObjectEffect(true).setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game)));
            this.addEffect((Effect)new CopyTargetStackObjectEffect(true).setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game)));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "When you next cast an instant spell, cast a sorcery spell, or activate a loyalty ability this turn, copy that spell or ability twice. You may choose new targets for the copies.";
    }
}

