/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class ReprocessEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("artifacts, creatures, and/or lands");

    public ReprocessEffect() {
        super(Outcome.Neutral);
        this.staticText = "Sacrifice any number of artifacts, creatures, and/or lands. Draw a card for each permanent sacrificed this way.";
    }

    private ReprocessEffect(ReprocessEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReprocessEffect copy() {
        return new ReprocessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = 0;
        TargetSacrifice toSacrifice = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)filter);
        if (player.choose(Outcome.Sacrifice, (Target)toSacrifice, source, game)) {
            for (UUID uuid : toSacrifice.getTargets()) {
                Permanent permanent = game.getPermanent(uuid);
                if (permanent == null) continue;
                permanent.sacrifice(source, game);
                ++amount;
            }
            player.drawCards(amount, source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

