/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class RescueFromTheUnderworldReturnEffect
extends OneShotEffect {
    RescueFromTheUnderworldReturnEffect() {
        super(Outcome.PutCreatureInPlay);
    }

    private RescueFromTheUnderworldReturnEffect(RescueFromTheUnderworldReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public RescueFromTheUnderworldReturnEffect copy() {
        return new RescueFromTheUnderworldReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                card = game.getCard(targetId);
                if (card == null) continue;
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            if (source.getTargets().get(1) != null) {
                for (UUID targetId : ((Target)source.getTargets().get(1)).getTargets()) {
                    Zone currentZone;
                    Player player;
                    card = game.getCard(targetId);
                    if (card == null || card.isFaceDown(game) || (player = game.getPlayer(card.getOwnerId())) == null || (currentZone = game.getState().getZone(card.getId())) != Zone.COMMAND && currentZone != Zone.GRAVEYARD && currentZone != Zone.EXILED) continue;
                    return player.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

