/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.StationAbility;
import mage.abilities.keyword.StationLevelAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

public final class RescueSkiff
extends CardImpl {
    private static final FilterCard filter = new FilterCard("creature or enchantment card from your graveyard");

    public RescueSkiff(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{5}{W}");
        this.subtype.add((Object)SubType.SPACECRAFT);
        EntersBattlefieldTriggeredAbility ability = new EntersBattlefieldTriggeredAbility((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect());
        ability.addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new StationAbility());
        this.addAbility((Ability)new StationLevelAbility(10).withLevelAbility((Ability)FlyingAbility.getInstance()).withPT(5, 6));
    }

    private RescueSkiff(RescueSkiff card) {
        super((CardImpl)card);
    }

    public RescueSkiff copy() {
        return new RescueSkiff(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
    }
}

