/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.common.LeavesBattlefieldAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.r.ResourcefulDefenseLeaveEffect;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ResourcefulDefenseTriggeredAbility
extends LeavesBattlefieldAllTriggeredAbility {
    ResourcefulDefenseTriggeredAbility() {
        super((Effect)new ResourcefulDefenseLeaveEffect(), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT);
        this.setTriggerPhrase("Whenever a permanent you control leaves the battlefield, if it had counters on it, ");
    }

    private ResourcefulDefenseTriggeredAbility(ResourcefulDefenseTriggeredAbility ability) {
        super((LeavesBattlefieldAllTriggeredAbility)ability);
    }

    public ResourcefulDefenseTriggeredAbility copy() {
        return new ResourcefulDefenseTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        Player controller = game.getPlayer(permanent.getControllerId());
        if (controller == null) {
            return false;
        }
        Counters counters = permanent.getCounters(game);
        if (counters.values().stream().mapToInt(Counter::getCount).noneMatch(x -> x > 0)) {
            return false;
        }
        this.getEffects().setValue("counters", (Object)counters);
        return true;
    }
}

