/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ResplendentMarshalEffect
extends OneShotEffect {
    ResplendentMarshalEffect() {
        super(Outcome.Benefit);
    }

    private ResplendentMarshalEffect(ResplendentMarshalEffect effect) {
        super((OneShotEffect)effect);
    }

    public ResplendentMarshalEffect copy() {
        return new ResplendentMarshalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        Card exiledCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller != null && sourceObject != null && exiledCard != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, source.getControllerId(), source, game)) {
                if (!permanent.shareCreatureTypes(game, (MageObject)exiledCard)) continue;
                permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
                if (game.isSimulation()) continue;
                game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " puts a +1/+1 counter on " + permanent.getLogName());
            }
            return true;
        }
        return false;
    }
}

