/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RestoreEffect
extends OneShotEffect {
    RestoreEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "Put target land card from a graveyard onto the battlefield under your control";
    }

    private RestoreEffect(RestoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public RestoreEffect copy() {
        return new RestoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card land = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller != null && game.getState().getZone(land.getId()) == Zone.GRAVEYARD) {
            controller.moveCards(land, Zone.BATTLEFIELD, source, game);
            return true;
        }
        return false;
    }
}

