/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class RetracedImageEffect
extends OneShotEffect {
    RetracedImageEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Reveal a card in your hand, then put that card onto the battlefield if it has the same name as a permanent";
    }

    private RetracedImageEffect(RetracedImageEffect effect) {
        super((OneShotEffect)effect);
    }

    public RetracedImageEffect copy() {
        return new RetracedImageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card chosenCard;
        TargetCardInHand target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (target = new TargetCardInHand()).canChoose(controller.getId(), source, game) && controller.choose(this.outcome, (Target)target, source, game) && (chosenCard = game.getCard(target.getFirstTarget())) != null) {
            CardsImpl cards = new CardsImpl();
            cards.add(chosenCard);
            controller.revealCards(source, (Cards)cards, game);
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
                if (!permanent.getName().equals(chosenCard.getName())) continue;
                return controller.moveCards(chosenCard, Zone.BATTLEFIELD, source, game);
            }
        }
        return false;
    }
}

