/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.common.CastFromGraveyardSourceCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.RobotBlueToken;

class RetrieveTheEsperEffect
extends OneShotEffect {
    RetrieveTheEsperEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 3/3 blue Robot Warrior artifact creature token. Then if this spell was cast from a graveyard, put two +1/+1 counters on that token";
    }

    private RetrieveTheEsperEffect(RetrieveTheEsperEffect effect) {
        super((OneShotEffect)effect);
    }

    public RetrieveTheEsperEffect copy() {
        return new RetrieveTheEsperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        RobotBlueToken token = new RobotBlueToken();
        token.putOntoBattlefield(1, game, source);
        if (!CastFromGraveyardSourceCondition.instance.apply(game, source)) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Optional.ofNullable(tokenId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(2), source, game));
        }
        return true;
    }
}

