/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingOrBlockingCreature;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RevealingWindEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterAttackingOrBlockingCreature("face-down creature that's attacking or blocking");

    public RevealingWindEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may look at each face-down creature that's attacking or blocking";
    }

    private RevealingWindEffect(RevealingWindEffect effect) {
        super((OneShotEffect)effect);
    }

    public RevealingWindEffect copy() {
        return new RevealingWindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            while (game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) > 0 && controller.chooseUse(this.outcome, "Look at a face-down attacking creature?", source, game)) {
                Card card;
                if (!controller.canRespond()) {
                    return false;
                }
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                if (!controller.chooseTarget(this.outcome, (Target)target, source, game) || (card = game.getCard(target.getFirstTarget())) == null) continue;
                controller.lookAtCards(sourceObject.getName(), card, game);
                game.informPlayers(controller.getLogName() + " look at a face-down attacking creature");
            }
        }
        return true;
    }

    static {
        filter.add((Predicate)FaceDownPredicate.instance);
    }
}

