/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.common.SourceTappedCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapAllControllerEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;

class ReveilleSquadTriggeredAbility
extends TriggeredAbilityImpl {
    public ReveilleSquadTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new UntapAllControllerEffect((FilterPermanent)new FilterCreaturePermanent("all creatures you control")), true);
    }

    private ReveilleSquadTriggeredAbility(ReveilleSquadTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ReveilleSquadTriggeredAbility copy() {
        return new ReveilleSquadTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        for (UUID attackerId : game.getCombat().getAttackers()) {
            if (!game.getCombat().getDefenderId(attackerId).equals(this.controllerId)) continue;
            return true;
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        return SourceTappedCondition.UNTAPPED.apply(game, (Ability)this);
    }

    public String getRule() {
        return "Whenever one or more creatures attack you, if {this} is untapped, you may untap all creatures you control.";
    }
}

