/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RevelationOfPowerEffect
extends OneShotEffect {
    RevelationOfPowerEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "If it has a counter on it, it also gains flying and lifelink until end of turn";
    }

    private RevelationOfPowerEffect(RevelationOfPowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RevelationOfPowerEffect copy() {
        return new RevelationOfPowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature != null) {
            for (Counter counter : targetCreature.getCounters(game).values()) {
                if (counter.getCount() <= 0) continue;
                game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance()), source);
                game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)LifelinkAbility.getInstance()), source);
                return true;
            }
        }
        return false;
    }
}

