/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;

class ReverberationEffect
extends ReplacementEffectImpl {
    ReverberationEffect() {
        super(Duration.EndOfTurn, Outcome.RedirectDamage);
        this.staticText = "All damage that would be dealt this turn by target sorcery spell is dealt to that spell's controller instead";
    }

    private ReverberationEffect(ReverberationEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ReverberationEffect copy() {
        return new ReverberationEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player targetsController;
        Spell targetSpell;
        Player controller = game.getPlayer(source.getControllerId());
        DamageEvent damageEvent = (DamageEvent)event;
        if (controller != null && (targetSpell = game.getStack().getSpell(source.getFirstTarget())) != null && (targetsController = game.getPlayer(targetSpell.getControllerId())) != null) {
            targetsController.damage(damageEvent.getAmount(), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), damageEvent.getAppliedEffects());
            return true;
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        Spell targetSpell = game.getStack().getSpell(source.getFirstTarget());
        if (targetSpell != null) {
            return damageEvent.getAmount() > 0;
        }
        return false;
    }
}

