/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.r.RevivalExperimentTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.GameState;
import mage.players.Player;
import mage.target.Target;

class RevivalExperimentEffect
extends OneShotEffect {
    RevivalExperimentEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "for each permanent type, return up to one card of that type from your graveyard to the battlefield. You lose 3 life for each card returned this way.";
    }

    private RevivalExperimentEffect(RevivalExperimentEffect effect) {
        super((OneShotEffect)effect);
    }

    public RevivalExperimentEffect copy() {
        return new RevivalExperimentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        RevivalExperimentTarget target = new RevivalExperimentTarget();
        player.choose(this.outcome, (Target)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        int toBattlefield = cards.stream().map(arg_0 -> ((GameState)game.getState()).getZone(arg_0)).filter(arg_0 -> Zone.BATTLEFIELD.equals(arg_0)).mapToInt(x -> 1).sum();
        player.loseLife(3 * toBattlefield, game, source, false);
        return true;
    }
}

