/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RhonasTheIndomitableRestrictionEffect
extends RestrictionEffect {
    RhonasTheIndomitableRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack or block unless you control another creature with power 4 or greater";
    }

    private RhonasTheIndomitableRestrictionEffect(RhonasTheIndomitableRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public RhonasTheIndomitableRestrictionEffect copy() {
        return new RhonasTheIndomitableRestrictionEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        if (permanent.getId().equals(source.getSourceId())) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                int permanentsOnBattlefield = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
                return permanentsOnBattlefield < 1;
            }
            return true;
        }
        return false;
    }
}

